/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.QueryResult;
import com.aptana.internal.index.core.DiskIndex;
import com.aptana.internal.index.core.MemoryIndex;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.CRC32;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    private static final int MATCH_RULE_INDEX_MASK = 27;
    private static final Map<String, Pattern> PATTERNS = new HashMap<String, Pattern>();
    public static final char DEFAULT_SEPARATOR = '/';
    private MemoryIndex memoryIndex;
    private DiskIndex diskIndex;
    ReadWriteLock monitor;
    private URI containerURI;

    private static StringBuffer appendAsRegEx(String pattern, StringBuffer buffer) {
        boolean isEscaped = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    if (!isEscaped) {
                        isEscaped = true;
                        break;
                    }
                    buffer.append("\\\\");
                    isEscaped = false;
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                case '?': {
                    if (!isEscaped) {
                        buffer.append('.');
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                case '*': {
                    if (!isEscaped) {
                        buffer.append(".*");
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                default: {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (isEscaped) {
            buffer.append("\\\\");
            isEscaped = false;
        }
        return buffer;
    }

    private static IPath computeIndexLocation(URI containerPath) {
        IPath path;
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(containerPath.toString().getBytes());
        String fileName = String.valueOf(Long.toString(crc.getValue())) + ".index";
        IndexPlugin plugin = IndexPlugin.getDefault();
        if (plugin != null && (path = plugin.getStateLocation()) != null) {
            return path.append(fileName);
        }
        return null;
    }

    public static boolean isMatch(String pattern, String word, int matchRule) {
        if (pattern == null) {
            return true;
        }
        int patternLength = pattern.length();
        int wordLength = word.length();
        if (patternLength == 0) {
            return matchRule != 0;
        }
        switch (matchRule) {
            case 0: {
                return patternLength == wordLength && pattern.equalsIgnoreCase(word);
            }
            case 1: {
                return patternLength <= wordLength && word.toLowerCase().startsWith(pattern.toLowerCase());
            }
            case 2: {
                return Index.patternMatch(pattern.toLowerCase(), word.toLowerCase());
            }
            case 16: {
                return Index.regexPatternMatch(pattern, word, false);
            }
            case 8: {
                return patternLength == wordLength && pattern.equals(word);
            }
            case 9: {
                return patternLength <= wordLength && word.startsWith(pattern);
            }
            case 10: {
                return Index.patternMatch(pattern, word);
            }
            case 24: {
                return Index.regexPatternMatch(pattern, word, true);
            }
        }
        return false;
    }

    private static boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    private static boolean patternMatch(String pattern, String word) {
        if (pattern.equals("*")) {
            return true;
        }
        Pattern p = PATTERNS.get(pattern);
        if (p == null) {
            int len = pattern.length();
            StringBuffer buffer = new StringBuffer(len + 10);
            if (len > 0 && Index.isWordChar(pattern.charAt(0))) {
                buffer.append("\\b");
            }
            Index.appendAsRegEx(pattern, buffer);
            if (len > 0 && Index.isWordChar(pattern.charAt(len - 1))) {
                buffer.append("\\b");
            }
            String regex = buffer.toString();
            p = Pattern.compile(regex);
            PATTERNS.put(pattern, p);
        }
        return p != null ? p.matcher(word).find() : false;
    }

    private static boolean regexPatternMatch(String regex, String word, boolean caseSensitive) {
        Pattern pattern = PATTERNS.get(regex);
        if (pattern == null) {
            try {
                pattern = caseSensitive ? Pattern.compile(regex) : Pattern.compile(regex, 2);
                PATTERNS.put(regex, pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return pattern != null ? pattern.matcher(word).find() : false;
    }

    protected Index(URI containerURI, boolean reuseExistingFile) throws IOException {
        this.containerURI = containerURI;
        this.memoryIndex = new MemoryIndex();
        this.monitor = new ReentrantReadWriteLock();
        IPath diskIndexPath = Index.computeIndexLocation(containerURI);
        if (diskIndexPath == null) {
            return;
        }
        String diskIndexPathString = diskIndexPath.getDevice() == null ? diskIndexPath.toString() : diskIndexPath.toOSString();
        this.enterWrite();
        try {
            this.diskIndex = new DiskIndex(diskIndexPathString);
            this.diskIndex.initialize(reuseExistingFile);
        }
        finally {
            this.exitWrite();
        }
    }

    public void addEntry(String category, String key, URI containerRelativeURI) {
        this.enterWrite();
        try {
            this.memoryIndex.addEntry(category, key, containerRelativeURI.toString());
        }
        finally {
            this.exitWrite();
        }
    }

    void deleteIndexFile() {
        File indexFile;
        if (Index.isTraceEnabled()) {
            Index.logTrace(MessageFormat.format("Deleting index ''{0}''", this));
        }
        if ((indexFile = this.getIndexFile()) != null && indexFile.exists()) {
            indexFile.delete();
        }
    }

    protected static void logTrace(String msg) {
        IdeLog.logTrace((Plugin)IndexPlugin.getDefault(), (String)msg, (String)"com.aptana.index.core/debug/indexer");
    }

    protected static boolean isTraceEnabled() {
        return IdeLog.isTraceEnabled((Plugin)IndexPlugin.getDefault(), (String)"com.aptana.index.core/debug/indexer");
    }

    private void enterRead() {
        if (this.monitor != null) {
            this.monitor.readLock().lock();
        }
    }

    private void enterWrite() {
        if (this.monitor != null) {
            this.monitor.writeLock().lock();
        }
    }

    private void exitRead() {
        if (this.monitor != null) {
            this.monitor.readLock().unlock();
        }
    }

    private boolean exitReadEnterWrite() {
        boolean result = false;
        if (this.monitor != null) {
            this.monitor.readLock().unlock();
            result = this.monitor.writeLock().tryLock();
        }
        return result;
    }

    private void exitWrite() {
        if (this.monitor != null) {
            this.monitor.writeLock().unlock();
        }
    }

    private void exitWriteEnterRead() {
        if (this.monitor != null) {
            this.exitWrite();
            this.enterRead();
        }
    }

    public List<String> getCategories() {
        HashSet<String> categories = new HashSet<String>();
        this.enterRead();
        try {
            categories.addAll(this.memoryIndex.getCategories());
            categories.addAll(this.diskIndex.getCategories());
        }
        finally {
            this.exitRead();
        }
        return new ArrayList<String>(categories);
    }

    public File getIndexFile() {
        return this.diskIndex == null ? null : this.diskIndex.indexFile;
    }

    public URI getRoot() {
        return this.containerURI;
    }

    private boolean hasChanged() {
        return this.memoryIndex.hasChanged();
    }

    public List<QueryResult> query(String[] categories, String key, int matchRule) {
        Map<String, QueryResult> results;
        block13: {
            results = null;
            try {
                try {
                    this.enterRead();
                    if (this.memoryIndex.shouldMerge() && this.exitReadEnterWrite()) {
                        try {
                            this.save(false);
                        }
                        finally {
                            this.exitWriteEnterRead();
                        }
                    }
                    int rule = matchRule & 0x1B;
                    if (this.memoryIndex.hasChanged()) {
                        results = this.diskIndex.addQueryResults(categories, key, rule, this.memoryIndex);
                        results = this.memoryIndex.addQueryResults(categories, key, rule, results);
                    } else {
                        results = this.diskIndex.addQueryResults(categories, key, rule, null);
                    }
                }
                catch (IOException e) {
                    if (e instanceof EOFException) {
                        e.printStackTrace();
                    }
                    IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                    this.exitRead();
                    PATTERNS.clear();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.exitRead();
                PATTERNS.clear();
                throw throwable;
            }
            this.exitRead();
            PATTERNS.clear();
        }
        return results == null ? null : new ArrayList(results.values());
    }

    public Set<String> queryDocumentNames(String substring) throws IOException {
        Set<String> results;
        this.enterRead();
        try {
            if (this.memoryIndex.hasChanged()) {
                results = this.diskIndex.addDocumentNames(substring, this.memoryIndex);
                results.addAll(this.memoryIndex.addDocumentNames(substring));
            } else {
                results = this.diskIndex.addDocumentNames(substring, null);
            }
        }
        finally {
            this.exitRead();
        }
        return results;
    }

    public void remove(URI containerRelativeURI) {
        String documentName = containerRelativeURI.toString();
        this.enterRead();
        try {
            if (Index.isTraceEnabled() && this.memoryIndex.hasDocument(documentName)) {
                String message = MessageFormat.format("Removing URI ''{0}'' from index ''{1}''", containerRelativeURI, this);
                Index.logTrace(message);
            }
        }
        finally {
            this.exitRead();
            this.enterWrite();
        }
        try {
            this.memoryIndex.remove(documentName);
        }
        finally {
            this.exitWrite();
        }
    }

    public void removeCategories(String ... categoryNames) {
        this.enterWrite();
        try {
            try {
                this.memoryIndex.removeCategories(categoryNames);
                this.diskIndex = this.diskIndex.removeCategories(categoryNames, this.memoryIndex);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)"An error occurred while removing categories from the index", (Throwable)e);
                this.exitWrite();
            }
        }
        finally {
            this.exitWrite();
        }
    }

    public void save() throws IOException {
        if (Index.isTraceEnabled()) {
            Index.logTrace(MessageFormat.format("Saving index ''{0}''", this));
        }
        this.save(true);
    }

    private void save(boolean lock) throws IOException {
        try {
            if (lock) {
                this.enterWrite();
            }
            if (!this.hasChanged()) {
                return;
            }
            try {
                int numberOfChanges = this.memoryIndex.numberOfChanges();
                this.diskIndex = this.diskIndex.mergeWith(this.memoryIndex);
                this.memoryIndex = new MemoryIndex();
                if (numberOfChanges > 1000) {
                    System.gc();
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            if (lock) {
                this.exitWrite();
            }
        }
    }

    public String toString() {
        return "Index for " + this.containerURI;
    }

    public URI getRelativeDocumentPath(URI path) {
        return this.containerURI.relativize(path);
    }

    public void reset() throws IOException {
        this.memoryIndex = new MemoryIndex();
        this.diskIndex = new DiskIndex(this.diskIndex.indexFile.getCanonicalPath());
        this.diskIndex.initialize(false);
    }
}

